'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================


Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveNo
End Sub

Private Sub Form_Open(Cancel As Integer)
    On Error GoTo Err_Form_Open

    Dim x As Long, a As Long, b As Long, c As Long, d As Long, e As Long, f As Long
    Dim Anzahl As Long, AnzahlMonat As Long, AnzahlKunden As Long, AnzahlTermine As Long, AnzahlGebuehren As Long, AnzahlRechnungen As Long
    Dim myNode As Object, myNodeJahr As Object, myNodeMonat, myNodeKontakte As Object, myNodeTermine As Object, myNodeRechnungen As Object, myNodeGebuehren As Object, myNodeSteuern As Object
    Dim IconName As String, FilterRechnungen As String, FilterTermine As String, FilterGebuehren As String, EintragText As String
    Dim JahrRechnung As Integer, JahrTermin As Integer, MonatTermin As Integer
    
    
    Dim dbs As Database
    Dim rstKunden, rstRechnungen, rstReMitKundenname, rstTermineGueltig, rstTermineGeloescht, rstGebuehren As Recordset
    
        
    'Vorbereitungen
    x = 1
    
    ' "spezielle" Fehlerbehandlung (fr MSCOMCTL.OCX) einschalten, die dann ausgelst wird, wenn
    ' das TreeView in der nchsten Zeile mit einem Fehler reagiert
    On Error GoTo Err_TreeView
    Me.TreeView_DatenbankExplorer.Sorted = False
        
    ' "normale" Fehlerbehandlung einschalten
    On Error GoTo Err_Form_Open
    
    'Baum"wurzel" anlegen
    Me.TreeView_DatenbankExplorer.Nodes.Add , , , "Terminabrechnung"
    '1. Ebene unterhalb "Terminabrechnung" soll ausgeklappt sein
    Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Item(1)
    myNode.Expanded = True
    myNode.Image = "IconUhr"
    myNode.ExpandedImage = "IconUhr"
    myNode.SelectedImage = "IconUhr"
    
    'ffnen der Kunden-, Rechnungs- und Termintabellen
    Set dbs = CurrentDb
    Set rstKunden = dbs.OpenRecordset("SELECT * FROM Kunden ORDER BY [Name1]")
    Set rstRechnungen = dbs.OpenRecordset("SELECT * FROM Rechnungen ORDER BY [Re_Jahr] DESC, [Re_bis] DESC, [Re_Datum] DESC, [Re_Nr] DESC")
    Set rstTermineGueltig = dbs.OpenRecordset("SELECT * FROM Termine ORDER BY [Start] DESC")
    Set rstTermineGeloescht = dbs.OpenRecordset("SELECT * FROM Termine_geloescht ORDER BY [Start] DESC")
    Set rstGebuehren = dbs.OpenRecordset("SELECT * FROM Gebuehren ORDER BY [gilt_ab] DESC")
    Set rstReMitKundenname = dbs.OpenRecordset("SELECT * FROM Abf_DbExplorer_Rech_mitKundenname ORDER BY [Re_Jahr] DESC, [Re_bis] DESC, [Re_Datum] DESC, [Re_Nr] DESC")
    
    
    a = x
    If rstKunden.RecordCount > 0 Then
        'wenn Kunden vorhanden sind, dann...
        'Einlesen der Kunden mit Rechnungen, Terminen und Gebhren
        rstKunden.MoveLast          'Recordset-Objekt auffllen!
        If rstKunden.RecordCount = 1 Then
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , rstKunden.RecordCount & " Kunde")   ' 4 = tvwChild
        Else
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , rstKunden.RecordCount & " Kunden")   ' 4 = tvwChild
        End If
        myNode.Image = "IconKontakt"
        myNode.ExpandedImage = "IconKontakt"
        myNode.SelectedImage = "IconKontakt"
        rstKunden.MoveFirst
        x = x + 1
        b = x
        Do While Not rstKunden.EOF
            EintragText = ""
            If Trim(rstKunden!PLZ) <> "" Then EintragText = rstKunden!PLZ
            If Trim(rstKunden!Ort) <> "" Then EintragText = EintragText & " " & rstKunden!Ort
            If Trim(rstKunden!Strasse) <> "" Then EintragText = EintragText & ", " & rstKunden!Strasse
            If EintragText <> "" Then EintragText = "  (" & EintragText & ")"
            If Trim(rstKunden!Name2) <> "" Then EintragText = ", " & Trim(rstKunden!Name2) & EintragText
            EintragText = Trim(rstKunden!Name1) & EintragText
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(b, 4, , EintragText)    ' 4 = tvwChild
            myNode.Image = "IconKontakt"
            myNode.ExpandedImage = "IconKontakt"
            myNode.SelectedImage = "IconKontakt"
            myNode.Key = """" & rstKunden!lfd_Nr & """"
            
            x = x + 1
            c = x
            FilterTermine = "[lfd_Nr_Kunde] = " & rstKunden!lfd_Nr
            rstTermineGueltig.FindFirst FilterTermine
            If Not rstTermineGueltig.NoMatch Then
                    Set myNodeTermine = Me.TreeView_DatenbankExplorer.Nodes.Add(c, 4, , "gltige Termine  (...)")    ' 4 = tvwChild
                    myNodeTermine.Image = "IconTermin"
                    myNodeTermine.ExpandedImage = "IconTermin"
                    myNodeTermine.SelectedImage = "IconTermin"
                    JahrTermin = 0
                    MonatTermin = 0
                    AnzahlTermine = 0
                    Anzahl = 0
                    AnzahlMonat = 0
                    x = x + 1
                    d = x
                    e = x
                    f = x
                    Set myNodeJahr = Nothing
                    rstTermineGueltig.FindFirst FilterTermine
                    Do While Not rstTermineGueltig.NoMatch
                        'falls Jahr zum vorherigen Termin abweicht, neues Jahr anlegen
                        If rstTermineGueltig!S_Jahr <> JahrTermin Then
                        
                            'bisherige Monatszeile mit der Anzahl pro Monat versehen
                            If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                            End If
                        
                            'bisherige Jahreszeile mit der Anzahl pro Jahr versehen
                            If Anzahl > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeJahr.Text = "Jahr " & JahrTermin & "  (" & Anzahl & ")"
                            End If
                            'Jahr fr den nchsten Durchlauf merken
                            JahrTermin = rstTermineGueltig!S_Jahr
                            'Jahreseintrag anlegen
                            EintragText = "Jahr " & JahrTermin & "  (...)"
                            Set myNodeJahr = Me.TreeView_DatenbankExplorer.Nodes.Add(d, 4, , EintragText)    ' 4 = tvwChild
                            myNodeJahr.Image = "IconKalender"
                            myNodeJahr.ExpandedImage = "IconKalender"
                            myNodeJahr.SelectedImage = "IconKalender"
                            myNodeJahr.Key = "Termin" & x
                            Anzahl = 0
                            AnzahlMonat = 0
                            MonatTermin = 0
                            x = x + 1
                            e = x
                            f = x
                        End If
                        
                        'falls Monat zum vorherigen Termin abweicht, neuen Monat anlegen
                        If rstTermineGueltig!S_Monat <> MonatTermin Then
                            'bisherige Monatszeile mit der Anzahl pro Monat versehen
                            If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                            End If
                            'Monat fr den nchsten Durchlauf merken
                            MonatTermin = rstTermineGueltig!S_Monat
                            'Jahreseintrag anlegen
                            EintragText = "Monat " & MonatTermin & "  (...)"
                            Set myNodeMonat = Me.TreeView_DatenbankExplorer.Nodes.Add(e, 4, , EintragText)    ' 4 = tvwChild
                            myNodeMonat.Image = "IconKalender"
                            myNodeMonat.ExpandedImage = "IconKalender"
                            myNodeMonat.SelectedImage = "IconKalender"
                            myNodeMonat.Key = "Termin" & x
                            AnzahlMonat = 0
                            x = x + 1
                            f = x
                        End If
                        
                        'eigentlicher Termineintrag
                        Select Case Format(rstTermineGueltig!Start, "Ddd")
                            Case "Mo"
                                EintragText = "Mo  "
                            Case "Di"
                                EintragText = "Di   "
                            Case "Mi"
                                EintragText = "Mi   "
                            Case "Do"
                                EintragText = "Do  "
                            Case "Fr"
                                EintragText = "Fr   "
                            Case "Sa"
                                EintragText = "Sa  "
                            Case "So"
                                EintragText = "So  "
                            Case Else
                                EintragText = "??  "
                        End Select
                        EintragText = EintragText & _
                            Format(rstTermineGueltig!Start, "Short Date") & " " & Format(rstTermineGueltig!Start, "Short Time") & _
                            " - " & Format(rstTermineGueltig!Ende, "Short Date") & " " & Format(rstTermineGueltig!Ende, "Short Time") & _
                            "   '" & rstTermineGueltig!Betreff & "'"
                        If (rstTermineGueltig!Su_Re_Netto <> 0) Or (Trim(rstTermineGueltig!Re_Nr) <> "") Then
                            EintragText = EintragText & "   (Netto: " & Format(rstTermineGueltig!Su_Re_Netto, "Currency") & _
                            "; " & rstTermineGueltig!Re_Nr & ")"
                        End If
                        Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(f, 4, , EintragText)    ' 4 = tvwChild
                        myNode.Image = "IconTermin"
                        myNode.ExpandedImage = "IconTermin"
                        myNode.SelectedImage = "IconTermin"
                        If rstTermineGueltig!Privat = True Then           'Privattermine Rot kennzeichnen
                            myNode.ForeColor = RGB(255, 0, 0)
                        End If
                        AnzahlTermine = AnzahlTermine + 1
                        Anzahl = Anzahl + 1
                        AnzahlMonat = AnzahlMonat + 1
                        x = x + 1
                        rstTermineGueltig.FindNext FilterTermine
                    Loop    'TermineGueltig.EOF
                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                myNodeJahr.Text = "Jahr " & JahrTermin & "  (" & Anzahl & ")"
                If AnzahlTermine = 1 Then
                    myNodeTermine.Text = AnzahlTermine & " gltiger Termin"
                Else
                    myNodeTermine.Text = AnzahlTermine & " gltige Termine"
                End If
            End If
            
            FilterTermine = "[lfd_Nr_Kunde] = " & rstKunden!lfd_Nr
            rstTermineGeloescht.FindFirst FilterTermine
            If Not rstTermineGeloescht.NoMatch Then
                    Set myNodeTermine = Me.TreeView_DatenbankExplorer.Nodes.Add(c, 4, , "gelschte Termine (...)")    ' 4 = tvwChild
                    myNodeTermine.Image = "IconTerminGeloescht"
                    myNodeTermine.ExpandedImage = "IconTerminGeloescht"
                    myNodeTermine.SelectedImage = "IconTerminGeloescht"
                    JahrTermin = 0
                    MonatTermin = 0
                    AnzahlTermine = 0
                    Anzahl = 0
                    AnzahlMonat = 0
                    x = x + 1
                    d = x
                    e = x
                    f = x
                    Set myNodeJahr = Nothing
                    rstTermineGeloescht.FindFirst FilterTermine
                    Do While Not rstTermineGeloescht.NoMatch
                        'falls Jahr zum vorherigen Termin abweicht, neues Jahr anlegen
                        If rstTermineGeloescht!S_Jahr <> JahrTermin Then
                            
                            'bisherige Monatszeile mit der Anzahl pro Monat versehen
                            If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                            End If
                            
                            'bisherige Jahreszeile mit der Anzahl pro Jahr versehen
                            If Anzahl > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeJahr.Text = "Jahr " & JahrTermin & "  (" & Anzahl & ")"
                            End If
                            'Jahr fr den nchsten Durchlauf merken
                            JahrTermin = rstTermineGeloescht!S_Jahr
                            'Jahreseintrag anlegen
                            EintragText = "Jahr " & JahrTermin & "  (...)"
                            Set myNodeJahr = Me.TreeView_DatenbankExplorer.Nodes.Add(d, 4, , EintragText)    ' 4 = tvwChild
                            myNodeJahr.Image = "IconKalender"
                            myNodeJahr.ExpandedImage = "IconKalender"
                            myNodeJahr.SelectedImage = "IconKalender"
                            myNodeJahr.Key = "Termin" & x
                            Anzahl = 0
                            AnzahlMonat = 0
                            MonatTermin = 0
                            x = x + 1
                            e = x
                            f = x
                        End If
                        
                        'falls Monat zum vorherigen Termin abweicht, neuen Monat anlegen
                        If rstTermineGeloescht!S_Monat <> MonatTermin Then
                            'bisherige Monatszeile mit der Anzahl pro Monat versehen
                            If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                            End If
                            'Monat fr den nchsten Durchlauf merken
                            MonatTermin = rstTermineGeloescht!S_Monat
                            'Jahreseintrag anlegen
                            EintragText = "Monat " & MonatTermin & "  (...)"
                            Set myNodeMonat = Me.TreeView_DatenbankExplorer.Nodes.Add(e, 4, , EintragText)    ' 4 = tvwChild
                            myNodeMonat.Image = "IconKalender"
                            myNodeMonat.ExpandedImage = "IconKalender"
                            myNodeMonat.SelectedImage = "IconKalender"
                            myNodeMonat.Key = "Termin" & x
                            AnzahlMonat = 0
                            x = x + 1
                            f = x
                        End If
                        
                        'eigentlicher Termineintrag
                        Select Case Format(rstTermineGeloescht!Start, "Ddd")
                            Case "Mo"
                                EintragText = "Mo  "
                            Case "Di"
                                EintragText = "Di   "
                            Case "Mi"
                                EintragText = "Mi   "
                            Case "Do"
                                EintragText = "Do  "
                            Case "Fr"
                                EintragText = "Fr   "
                            Case "Sa"
                                EintragText = "Sa  "
                            Case "So"
                                EintragText = "So  "
                            Case Else
                                EintragText = "??  "
                        End Select
                        EintragText = EintragText & _
                            Format(rstTermineGeloescht!Start, "Short Date") & " " & Format(rstTermineGeloescht!Start, "Short Time") & _
                            " - " & Format(rstTermineGeloescht!Ende, "Short Date") & " " & Format(rstTermineGeloescht!Ende, "Short Time") & _
                            "   '" & rstTermineGeloescht!Betreff & "'"
                        If (rstTermineGeloescht!Su_Re_Netto <> 0) Or (Trim(rstTermineGeloescht!Re_Nr) <> "") Then
                            EintragText = EintragText & "   (Netto: " & Format(rstTermineGeloescht!Su_Re_Netto, "Currency") & _
                            "; " & rstTermineGeloescht!Re_Nr & ")"
                        End If
                        Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(f, 4, , EintragText)    ' 4 = tvwChild
                        myNode.Image = "IconTerminGeloescht"
                        myNode.ExpandedImage = "IconTerminGeloescht"
                        myNode.SelectedImage = "IconTerminGeloescht"
                        If rstTermineGeloescht!Privat = True Then           'Privattermine Rot kennzeichnen
                            myNode.ForeColor = RGB(255, 0, 0)
                        End If
                        AnzahlTermine = AnzahlTermine + 1
                        Anzahl = Anzahl + 1
                        AnzahlMonat = AnzahlMonat + 1
                        x = x + 1
                        rstTermineGeloescht.FindNext FilterTermine
                    Loop    'TermineGeloescht.EOF
                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                myNodeJahr.Text = "Jahr " & JahrTermin & "  (" & Anzahl & ")"
                If AnzahlTermine = 1 Then
                    myNodeTermine.Text = AnzahlTermine & " gelschter Termin"
                Else
                    myNodeTermine.Text = AnzahlTermine & " gelschte Termine"
                End If
            End If
            
            FilterRechnungen = "[lfd_Nr_Kunde] = " & rstKunden!lfd_Nr
            rstRechnungen.FindFirst FilterRechnungen
            If Not rstRechnungen.NoMatch Then
                Set myNodeRechnungen = Me.TreeView_DatenbankExplorer.Nodes.Add(c, 4, , "Rechnungen  (...)")    ' 4 = tvwChild
                myNodeRechnungen.Image = "IconDokument"
                myNodeRechnungen.ExpandedImage = "IconDokument"
                myNodeRechnungen.SelectedImage = "IconDokument"
                AnzahlRechnungen = 0
                JahrRechnung = 0
                MonatTermin = 0
                AnzahlTermine = 0
                Anzahl = 0
                AnzahlMonat = 0
                x = x + 1
                d = x
                e = x
                f = x
                Set myNodeJahr = Nothing
                rstRechnungen.FindFirst FilterRechnungen
                Do While Not rstRechnungen.NoMatch
                    'falls Jahr zur vorherigen Rechnung abweicht, neues Jahr anlegen
                    If rstRechnungen!Re_Jahr <> JahrRechnung Then
                        
                        'bisherige Monatszeile mit der Anzahl pro Monat versehen
                        If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                            myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                        End If
                        
                        'bisherige Jahreszeile mit der Anzahl pro Jahr versehen
                        If Anzahl > 0 Then              'ersten leeren Eintrag abfangen
                            myNodeJahr.Text = "Jahr " & JahrRechnung & "  (" & Anzahl & ")"
                        End If
                        'Jahr fr den nchsten Durchlauf merken
                        JahrRechnung = rstRechnungen!Re_Jahr
                        'Jahreseintrag anlegen
                        EintragText = "Jahr " & JahrRechnung & "  (...)"
                        Set myNodeJahr = Me.TreeView_DatenbankExplorer.Nodes.Add(d, 4, , EintragText)    ' 4 = tvwChild
                        myNodeJahr.Image = "IconKalender"
                        myNodeJahr.ExpandedImage = "IconKalender"
                        myNodeJahr.SelectedImage = "IconKalender"
                        myNodeJahr.Key = "Rechnung" & x
                        Anzahl = 0
                        AnzahlMonat = 0
                        MonatTermin = 0
                        x = x + 1
                        e = x
                        f = x
                    End If
                    
                    'falls Monat zum vorherigen Termin abweicht, neuen Monat anlegen
                    ''If Month(rstRechnungen!Re_Datum) <> MonatTermin Then
                    If Month(rstRechnungen!Re_bis) <> MonatTermin Then
                        'bisherige Monatszeile mit der Anzahl pro Monat versehen
                        If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                            myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                        End If
                        'Monat fr den nchsten Durchlauf merken
                        ''MonatTermin = Month(rstRechnungen!Re_Datum)
                        MonatTermin = Month(rstRechnungen!Re_bis)
                        'Jahreseintrag anlegen
                        EintragText = "Monat " & MonatTermin & "  (...)"
                        Set myNodeMonat = Me.TreeView_DatenbankExplorer.Nodes.Add(e, 4, , EintragText)    ' 4 = tvwChild
                        myNodeMonat.Image = "IconKalender"
                        myNodeMonat.ExpandedImage = "IconKalender"
                        myNodeMonat.SelectedImage = "IconKalender"
                        myNodeMonat.Key = "Termin" & x
                        AnzahlMonat = 0
                        x = x + 1
                        f = x
                    End If
                    
                    'eigentlicher Rechnungseintrag
                    Select Case Format(rstRechnungen!Re_Datum, "Ddd")
                        Case "Mo"
                            EintragText = "Mo  "
                        Case "Di"
                            EintragText = "Di   "
                        Case "Mi"
                            EintragText = "Mi   "
                        Case "Do"
                            EintragText = "Do  "
                        Case "Fr"
                            EintragText = "Fr   "
                        Case "Sa"
                            EintragText = "Sa  "
                        Case "So"
                            EintragText = "So  "
                        Case Else
                            EintragText = "??  "
                    End Select
                    EintragText = EintragText & rstRechnungen!Re_Datum & "  (" & _
                        Format(Month(rstRechnungen!Re_von), "00") & "-" & Format(Month(rstRechnungen!Re_bis), "00") & _
                        "/" & Format(rstRechnungen!Re_Jahr, "0000") & ")  " & rstRechnungen!Re_Nr
                    If rstRechnungen!Re_Storno = True Then
                        EintragText = EintragText & "  [S]  "
                    Else
                        EintragText = EintragText & "        "
                    End If
                    EintragText = EintragText & Format(rstRechnungen!Re_Brutto, "Currency") & _
                        "  (Netto " & Format(rstRechnungen!Re_Netto, "Currency") & " + "
                        If rstRechnungen!MwSt_Splitting = True Then
                            EintragText = EintragText & "div."
                        Else
                            EintragText = EintragText & Format(rstRechnungen!MwSt_Satz, "#,##0.00")
                        End If
                        EintragText = EintragText & " % MwSt " & Format(rstRechnungen!Re_MwSt, "Currency") & ")"
                    Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(f, 4, , EintragText)    ' 4 = tvwChild
                    myNode.Image = "IconDokument"
                    myNode.ExpandedImage = "IconDokument"
                    myNode.SelectedImage = "IconDokument"
                    'myNode.Key = """" & rstRechnungen!lfd_Nr & """"    'Key-Fehler?
                    myNode.Key = """" & rstRechnungen!lfd_Nr & """" & "Rechnung"
                    AnzahlRechnungen = AnzahlRechnungen + 1
                    Anzahl = Anzahl + 1
                    AnzahlMonat = AnzahlMonat + 1
                    x = x + 1
                    rstRechnungen.FindNext FilterRechnungen
                Loop    'Rechnungen.EOF
                myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                myNodeJahr.Text = "Jahr " & JahrRechnung & "  (" & Anzahl & ")"
                If AnzahlRechnungen = 1 Then
                    myNodeRechnungen.Text = AnzahlRechnungen & " Rechnung"
                Else
                    myNodeRechnungen.Text = AnzahlRechnungen & " Rechnungen"
                End If
            End If
            
            FilterGebuehren = "[lfd_Nr_Kunde] = " & rstKunden!lfd_Nr
            rstGebuehren.FindFirst FilterGebuehren
            If Not rstGebuehren.NoMatch Then
                Set myNodeGebuehren = Me.TreeView_DatenbankExplorer.Nodes.Add(c, 4, , "individuelle Preise  (...)")    ' 4 = tvwChild
                myNodeGebuehren.Image = "IconEuro"
                myNodeGebuehren.ExpandedImage = "IconEuro"
                myNodeGebuehren.SelectedImage = "IconEuro"
                Anzahl = 0
                x = x + 1
                d = x
                rstGebuehren.FindFirst FilterGebuehren
                Do While Not rstGebuehren.NoMatch
                    EintragText = "ab " & rstGebuehren!gilt_ab & " = " & Format(rstGebuehren!Std_Satz, "Currency") & "/h"
                    Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(d, 4, , EintragText)    ' 4 = tvwChild
                    myNode.Image = "IconEuro"
                    myNode.ExpandedImage = "IconEuro"
                    myNode.SelectedImage = "IconEuro"
                    Anzahl = Anzahl + 1
                    x = x + 1
                    rstGebuehren.FindNext FilterGebuehren
                Loop    'Gebuehren.EOF
                If Anzahl = 1 Then
                    myNodeGebuehren.Text = Anzahl & " individueller Preis"
                Else
                    myNodeGebuehren.Text = Anzahl & " individuelle Preise"
                End If
            End If
                    
            rstKunden.MoveNext
        Loop    'Kunden.EOF
    Else        'Kunden vorhanden?
        'wenn noch keine Kunden vorhanden
        Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , "0 Kunden")   ' 4 = tvwChild
        myNode.Image = "IconKontakt"
        myNode.ExpandedImage = "IconKontakt"
        myNode.SelectedImage = "IconKontakt"
        x = x + 1
    End If      'Kunden vorhanden?
    
    
    
    
    If rstReMitKundenname.RecordCount > 0 Then
        'wenn Rechnungen vorhanden sind, dann...
        'Einlesen der Rechnungen
        rstReMitKundenname.MoveLast          'Recordset-Objekt auffllen!
        If rstReMitKundenname.RecordCount = 1 Then
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , rstReMitKundenname.RecordCount & " Rechnung")   ' 4 = tvwChild
        Else
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , rstReMitKundenname.RecordCount & " Rechnungen")   ' 4 = tvwChild
        End If
        myNode.Image = "IconDokument"
        myNode.ExpandedImage = "IconDokument"
        myNode.SelectedImage = "IconDokument"
        rstReMitKundenname.MoveFirst
        JahrRechnung = 0
        AnzahlRechnungen = 0
        MonatTermin = 0
        AnzahlMonat = 0
        AnzahlTermine = 0
        Anzahl = 0
        x = x + 1
        b = x
        c = x
        d = x
        Do While Not rstReMitKundenname.EOF
            'falls Jahr zur vorherigen Rechnung abweicht, neues Jahr anlegen
            If rstReMitKundenname!Re_Jahr <> JahrRechnung Then
                
                'bisherige Monatszeile mit der Anzahl pro Monat versehen
                If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                    myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                End If
                
                'bisherige Jahreszeile mit der Anzahl pro Jahr versehen
                If Anzahl > 0 Then              'ersten leeren Eintrag abfangen
                    myNodeJahr.Text = "Jahr " & JahrRechnung & "  (" & Anzahl & ")"
                End If
                'Jahr fr den nchsten Durchlauf merken
                JahrRechnung = rstReMitKundenname!Re_Jahr
                'Jahreseintrag anlegen
                EintragText = "Jahr " & JahrRechnung & "  (...)"
                Set myNodeJahr = Me.TreeView_DatenbankExplorer.Nodes.Add(b, 4, , EintragText)    ' 4 = tvwChild
                myNodeJahr.Image = "IconKalender"
                myNodeJahr.ExpandedImage = "IconKalender"
                myNodeJahr.SelectedImage = "IconKalender"
                myNodeJahr.Key = "RechnungListe" & x
                MonatTermin = 0
                AnzahlMonat = 0
                Anzahl = 0
                x = x + 1
                c = x
                d = x
            End If
            
            'falls Monat zum vorherigen Termin abweicht, neuen Monat anlegen
            ''If Month(rstReMitKundenname!Re_Datum) <> MonatTermin Then
            If Month(rstReMitKundenname!Re_bis) <> MonatTermin Then
                'bisherige Monatszeile mit der Anzahl pro Monat versehen
                If AnzahlMonat > 0 Then        'ersten leeren Eintrag abfangen
                    myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
                End If
                'Monat fr den nchsten Durchlauf merken
                ''MonatTermin = Month(rstReMitKundenname!Re_Datum)
                MonatTermin = Month(rstReMitKundenname!Re_bis)
                'Jahreseintrag anlegen
                EintragText = "Monat " & MonatTermin & "  (...)"
                Set myNodeMonat = Me.TreeView_DatenbankExplorer.Nodes.Add(c, 4, , EintragText)    ' 4 = tvwChild
                myNodeMonat.Image = "IconKalender"
                myNodeMonat.ExpandedImage = "IconKalender"
                myNodeMonat.SelectedImage = "IconKalender"
                myNodeMonat.Key = "Termin" & x
                AnzahlMonat = 0
                x = x + 1
                d = x
            End If
            
            'eigentlicher Rechnungseintrag
            Select Case Format(rstReMitKundenname!Re_Datum, "Ddd")
                Case "Mo"
                    EintragText = "Mo  "
                Case "Di"
                    EintragText = "Di   "
                Case "Mi"
                    EintragText = "Mi   "
                Case "Do"
                    EintragText = "Do  "
                Case "Fr"
                    EintragText = "Fr   "
                Case "Sa"
                    EintragText = "Sa  "
                Case "So"
                    EintragText = "So  "
                Case Else
                    EintragText = "??  "
            End Select
            
            EintragText = EintragText & rstReMitKundenname!Re_Datum & "  (" & _
                Format(Month(rstReMitKundenname!Re_von), "00") & "-" & Format(Month(rstReMitKundenname!Re_bis), "00") & _
                "/" & Format(rstReMitKundenname!Re_Jahr, "0000") & ")  " & rstReMitKundenname!Re_Nr
            
            If rstReMitKundenname!Re_Storno = True Then
                EintragText = EintragText & "  [S]  "
            Else
                EintragText = EintragText & "        "
            End If
            EintragText = EintragText & Format(rstReMitKundenname!Re_Brutto, "Currency") & _
                "  (" & rstReMitKundenname!Name1 & ")"
            Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(d, 4, , EintragText)    ' 4 = tvwChild
            myNode.Image = "IconDokument"
            myNode.ExpandedImage = "IconDokument"
            myNode.SelectedImage = "IconDokument"
            ' "RechnungGesamtliste" fr eindeutigen Schlssel, "KundenNummer:" zur Trennung beider Schlssel
            myNode.Key = """" & "RechnungGesamtliste" & rstReMitKundenname!lfd_Nr & "KundenNummer" & rstReMitKundenname!lfd_Nr_Kunde & """"
            AnzahlRechnungen = AnzahlRechnungen + 1
            Anzahl = Anzahl + 1
            AnzahlMonat = AnzahlMonat + 1
            x = x + 1
            rstReMitKundenname.MoveNext
        Loop    'Rechnungen.EOF
        myNodeMonat.Text = "Monat " & Format(MonatTermin, "00") & "  (" & AnzahlMonat & ")"
        myNodeJahr.Text = "Jahr " & JahrRechnung & "  (" & Anzahl & ")"
    Else        'Rechnungen vorhanden?
        'wenn noch keine Rechnungen vorhanden
        Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Add(a, 4, , "0 Rechnungen")   ' 4 = tvwChild
        myNode.Image = "IconDokument"
        myNode.ExpandedImage = "IconDokument"
        myNode.SelectedImage = "IconDokument"
        x = x + 1
    End If      'Rechnungen vorhanden?
    
    
    'Tabellen wieder schlieen
    rstKunden.Close
    rstRechnungen.Close
    rstReMitKundenname.Close
    rstTermineGueltig.Close
    rstTermineGeloescht.Close
    rstGebuehren.Close
    Set dbs = Nothing
    
    
    'Falls nur 1 Kunde existiert, dessen Ordner aufklappen
    Set myNode = Me.TreeView_DatenbankExplorer.Nodes.Item(1)
    If myNode.Children = 1 Then
        Set myNode = myNode.Child
        myNode.Expanded = True
    End If
    
    'Ansicht aktualisieren
        'Me.TreeView_DatenbankExplorer.Sorted = True
    Me.TreeView_DatenbankExplorer.Refresh
    


Exit_Form_Open:
    Exit Sub

Err_Form_Open:
    MsgBox "Auf der Maske ist ein Fehler aufgetreten.", vbCritical + vbOKOnly, "Fehler"
    MsgBox err.Description
    Resume Exit_Form_Open

Err_TreeView:
    MsgBox "Die Anzeige der Baumstruktur auf der zu ffnenden Maske konnte nicht initialisiert werden." & _
        vbNewLine & vbNewLine & "Bitte prfen Sie, ob die Microsoft-Datei MSCOMCTL.OCX " & _
        "(in der richtigen Version) installiert und im System registiert ist. " & _
        "Eine Anleitung zur Installation finden Sie im Handbuch zur Terminabrechnung.", vbCritical + vbOKOnly, "Fehler"
    FehlerFormularOeffnen = True
    'MsgBox Err.Description
    Resume Exit_Form_Open

    
End Sub

Private Sub Form_Resize()
    On Error Resume Next
    Me.TreeView_DatenbankExplorer.Width = (Me.WindowWidth - 700)
    Me.TreeView_DatenbankExplorer.Height = (Me.WindowHeight - 1700)
End Sub

Private Sub TreeView_DatenbankExplorer_DblClick()
    Dim myNode As Object
    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim strFilterRechnung, strFilterKunde, strFilterSteuer, Schluessel, KeyRechnung, KeyKunde As String
    
    'aktuellen Key merken
    Schluessel = Me.TreeView_DatenbankExplorer.SelectedItem.Key
    'leeren Schlssel abfangen
    If Schluessel = "" Then Exit Sub
    
    'Prfen, ob im Key "RechnungGesamtliste" enthalten ist,
    '   da dann der Eintrag in der RechnungGesamtliste angeklickt wurde und
    '   zustzlich den Kundenschlssel enthlt
    If InStr(Schluessel, "RechnungGesamtliste") Then
        KeyKunde = Mid(Schluessel, (InStr(Schluessel, "KundenNummer") + 12), (Len(Schluessel) - InStr(Schluessel, "KundenNummer") - 12))
        KeyRechnung = Mid(Schluessel, 21, (InStr(Schluessel, "KundenNummer") - 21))
    
    Else
        'wenn "RechnungGesamtliste" im Key nicht enthalten ist...
        
        'Prfen, ob ber-ber-geordnetes Objekt gleich "Rechnung"-Ebene ist (Monatsebene berspringen!)
        Set myNode = Me.TreeView_DatenbankExplorer.SelectedItem.Parent
        Set myNode = myNode.Parent
        Select Case Left(myNode.Key, 8)
            Case "Rechnung"
                'wenn markiertes Element eine Rechnung ist...
                '...Key des Kunden ermitteln (entspr. Anzahl Ebenen nach oben gehen)
                Set myNode = myNode.Parent
                Set myNode = myNode.Parent
                KeyKunde = Mid(myNode.Key, 2, (Len(myNode.Key) - 2))
                KeyRechnung = Mid(Schluessel, 2, (Len(Schluessel) - 10))    '-10 enthlt -8 fr Abzug des Wortes "Rechnung" vom Ende des Keys
            Case Else
                'ansonsten Abbruch
                Exit Sub
        End Select
    End If          ' "RechnungGesamtliste" im Key?
    
    
    'Hinweis, wenn diese Rechnung bereits storniert wurde
    Schluessel = "Rechnung"
    If InStr(Me.TreeView_DatenbankExplorer.SelectedItem.Text, " [S] ") Then
        'Wenn Stornobeleg angezeigt werden soll, dann weiter, sonst Abbruch
        If MsgBox("Diese Rechnung wurde bereits storniert." & vbNewLine & _
            "Mchten Sie die Rechnung [Ja] oder den Stornobeleg [Nein] sehen?", _
            vbQuestion + vbYesNo + vbDefaultButton2, "Storno") = vbNo Then
                Schluessel = "Storno"
        End If
    End If
    
        
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
        'Gre des Reportfensters und Berichts-Zoom optimieren
        'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
        AnwendungGroesseErmitteln
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    
    'SQL-Texte vorbereiten
    strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & KeyRechnung
    strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & KeyKunde
    strFilterSteuer = "SELECT * FROM Rechnungen_MwSt WHERE Rechnungen_MwSt.lfd_Nr_Re=" & KeyRechnung & " ORDER BY Rechnungen_MwSt.Prozent;"
    'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
    dbs.QueryDefs.Refresh
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungDaten"
    Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungKunde"
    Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungMwSt"
    Set qdf = dbs.CreateQueryDef("Abf_RechnungMwSt", strFilterSteuer)
    dbs.QueryDefs.Refresh
    
    If Schluessel = "Rechnung" Then
        'Rechnungsformular anzeigen
        On Error GoTo ERR_Rechnung
        DoCmd.OpenReport FormularRechnungName, acPreview
ERR_Rechnung_weiter:
        On Error GoTo 0
    Else
        'Stornoformular anzeigen
        On Error GoTo ERR_Storno
        DoCmd.OpenReport FormularStornoName, acPreview
ERR_Storno_weiter:
        On Error GoTo 0
    End If
    
    
        'Berichtsfenster nun auf Anwendungsgre zoomen
        DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
        'Berichtsvorschau auf ganzes Blatt zoomen
        DoCmd.RunCommand acCmdFitToWindow
    
    
    'Tabellen schlieen
    qdf.Close
    Set dbs = Nothing
        
    Exit Sub
    
    
    
ERR_Rechnung:
    DoCmd.OpenReport "Rechnung_Hauptformular", acPreview
    Resume ERR_Rechnung_weiter

ERR_Storno:
    DoCmd.OpenReport "Storno_Hauptformular", acPreview
    Resume ERR_Storno_weiter
        
    
End Sub
Private Sub Befehl109_Click()
On Error GoTo Err_Befehl109_Click


    DoCmd.GoToRecord , , acFirst

Exit_Befehl109_Click:
    Exit Sub

Err_Befehl109_Click:
    MsgBox err.Description
    Resume Exit_Befehl109_Click
    
End Sub
